
// CreateAndDestroy class definition.
// Member functions defined in CreateAndDestroy.cpp.
#include <string>
using namespace std;

#ifndef CREATE_H
#define CREATE_H

class CreateAndDestroy 
{
public:
  CreateAndDestroy( int, string ); // constructor
  ~CreateAndDestroy(); // destructor
private:
  int objectID; // ID number for object
  string message; // message describing object
}; // end class CreateAndDestroy

#endif


// CreateAndDestroy class member-function definitions.
#include <iostream>
// #include "CreateAndDestroy.h" // include CreateAndDestroy class definition
using namespace std;

// constructor
CreateAndDestroy::CreateAndDestroy( int ID, string messageString )
{
  objectID = ID; // set object's ID number
  message = messageString; // set object's descriptive message

  cout << "Object " << objectID << "   constructor runs   " 
       << message << endl;
} // end CreateAndDestroy constructor

// destructor
CreateAndDestroy::~CreateAndDestroy()
{ 
  // output newline for certain objects; helps readability
  cout << ( objectID == 1 || objectID == 6 ? "\n" : "" );

  cout << "Object " << objectID << "   destructor runs    " 
       << message << endl; 
} // end ~CreateAndDestroy destructor


// Demonstrating the order in which constructors and 
// destructors are called.
#include <iostream>
// #include "CreateAndDestroy.h" // include CreateAndDestroy class definition
using namespace std;

void create( void ); // prototype

CreateAndDestroy first( 1, "(global before main)" ); // global object

int main()
{
  cout << "\nMAIN FUNCTION: EXECUTION BEGINS" << endl;
  CreateAndDestroy second( 2, "(local automatic in main)" );
  static CreateAndDestroy third( 3, "(local static in main)" );
   
  create(); // call function to create objects

  cout << "\nMAIN FUNCTION: EXECUTION RESUMES" << endl;
  CreateAndDestroy fourth( 4, "(local automatic in main)" );
  cout << "\nMAIN FUNCTION: EXECUTION ENDS" << endl;
} // end main

// function to create objects
void create( void )
{
  cout << "\nCREATE FUNCTION: EXECUTION BEGINS" << endl;
  CreateAndDestroy fifth( 5, "(local automatic in create)" );
  static CreateAndDestroy sixth( 6, "(local static in create)" );
  CreateAndDestroy seventh( 7, "(local automatic in create)" );
  cout << "\nCREATE FUNCTION: EXECUTION ENDS" << endl;
} // end function create
